<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * DepartmentAllegroCategoryItem
 *
 * @ORM\Table(name="departments_allegro_category_items")
 * @ORM\Entity
 *
 * @ExclusionPolicy("all")
 */
class DepartmentAllegroCategoryItem
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="department_id", type="integer")
     */
    private $departmentId;

    /**
     * @var integer
     *
     * @ORM\Column(name="item_id", type="integer")
     */
    private $itemId;

    /**
     * @var integer $quantity
     *
     * @ORM\Column(name="quantity", type="integer")
     */
    private $quantity;

    /**
     * @ORM\ManyToOne(targetEntity="Department",inversedBy="items")
     * @ORM\JoinColumn(name="department_id", referencedColumnName="id")
     */
    private $department;

    /**
     * @ORM\ManyToOne(targetEntity="\Import\ApiBundle\Entity\AllegroCategoryItem",inversedBy="departmentItems")
     * @ORM\JoinColumn(name="item_id", referencedColumnName="id")
     */
    private $item;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set departmentId
     *
     * @param integer $departmentId
     * @return DepartmentAllegroCategoryItem
     */
    public function setDepartmentId($departmentId)
    {
        $this->departmentId = $departmentId;
    
        return $this;
    }

    /**
     * Get departmentId
     *
     * @return integer 
     */
    public function getDepartmentId()
    {
        return $this->departmentId;
    }

    /**
     * Set itemId
     *
     * @param integer $itemId
     * @return DepartmentAllegroCategoryItem
     */
    public function setItemId($itemId)
    {
        $this->itemId = $itemId;
    
        return $this;
    }

    /**
     * Get itemId
     *
     * @return integer 
     */
    public function getItemId()
    {
        return $this->itemId;
    }

    /**
     * Set quantity
     *
     * @param integer $quantity
     * @return DepartmentAllegroCategoryItem
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;
    
        return $this;
    }

    /**
     * Get quantity
     *
     * @return integer 
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * Set department
     *
     * @param \VM\ApiBundle\Entity\Department $department
     * @return DepartmentAllegroCategoryItem
     */
    public function setDepartment(\VM\ApiBundle\Entity\Department $department = null)
    {
        $this->department = $department;
    
        return $this;
    }

    /**
     * Get department
     *
     * @return \VM\ApiBundle\Entity\Department 
     */
    public function getDepartment()
    {
        return $this->department;
    }

    /**
     * Set item
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItem $item
     * @return DepartmentAllegroCategoryItem
     */
    public function setItem(\Import\ApiBundle\Entity\AllegroCategoryItem $item = null)
    {
        $this->item = $item;
    
        return $this;
    }

    /**
     * Get item
     *
     * @return \Import\ApiBundle\Entity\AllegroCategoryItem 
     */
    public function getItem()
    {
        return $this->item;
    }
}